IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[P_EST_NF_ENT_GERA_PRE_FATURA]') AND type in (N'P', N'PC'))
begin
	DROP PROCEDURE P_EST_NF_ENT_GERA_PRE_FATURA
end
GO
go
CREATE PROCEDURE P_EST_NF_ENT_GERA_PRE_FATURA (@CD_EMP INT,
											   @CD_FILIAL INT,
											   @CD_DEST INT,
											   @CD_NT_MOV INT,
											   @CD_NF_ENTRADA INT)
AS
DECLARE @CD_PED INT
SET @CD_PED=ISNULL((SELECT
				MAX(CD_PED)
			 FROM
				EST_PED_VD
			 WHERE
				CD_EMP=@CD_EMP 
				AND CD_FILIAL=@CD_FILIAL),0)+1


INSERT INTO EST_PED_VD
	(CD_EMP
	,CD_FILIAL
	,CD_PED
	,CD_CLI
	,CD_VEND
	,CD_NT_MOV
	,DT_EMI_PED
	,VLR_TOT_PED
	,CD_COND_PGTO
	,NM_COMPRADOR
	,NM_TRANSP
	,FRETE
	,OBS
	,CD_USU
	,STS_PED
	,DT_FAT
	,VLR_TOT_PROD
	,VLR_DESC
	,DT_VALID
	,DT_CAD
	,DT_ULT_ATU
	,DT_BX
	,TP_BX
	,HORA_CAD
	,TP_PED
	,VLR_FRETE
	,OBS_NF1
	,OBS_NF2
	,PRZ_ENTRG
	,PRZ_VLD
	,COB
	,QT_VOL
	,DT_GRAVACAO
	,BLOQ_FATURAMENTO
	,VLR_ICMS_SUBS
	,VLR_ICMS_RETIDO
	,VLR_OUTROS_IT
	,FLAG_VALID_TRIB
	,XML_PEDIDO
	,FLAG_REALIZAR_FAT
	,DT_NF_SAIDA
	,FLAG_NAO_CALCULAR_IMPOSTO
	,VLR_BASE_ICMS
	,VLR_ICMS
	,VLR_BASE_ICMS_ST
	,VLR_IPI
	,ESP_VOL
	,MC_VOL
	,NR_VOL
	,PESO_VOL
	,PESO_LIQ_VOL
	,OBS_NF4
	,OBS_NF5
	,OBS_NF6
	,OBS_NF7
	,OBS_NF8
	,OBS_NF9
	,OBS_NF10
	,OBS_NF11
	,VLR_RESSARCIMENTO_BASE_SUBST
	,VLR_RESSARCIMENTO_ICMS_SUBST
	,VLR_ADJ_BASE_ICMS
	,VLR_ADJ_ICMS
	,CD_TRANSP
	,PLACA_VEIC
	,PLACA_UF
	,CGC_CPF_TRANSP
	,ENDE_TRANSP
	,DS_CID_TRANSP
	,UF_TRANSP
	,INSC_EST_TRANSP
	,EMAIL_TRANSP
	,DT_TRANSACAO
	,CD_CTR_DEVO)
SELECT
	CD_EMP,
	CD_FILIAL,
	@CD_PED,
	@CD_DEST,
	0 AS CD_VEND,
	@CD_NT_MOV,
    CONVERT(VARCHAR(10),GETDATE(),112) AS DT_EMI_PED,
	VLR_NF AS VLR_TOT_PED,
	0 AS CD_COND_PGTO,
	'' AS NM_COMPRADOR,
	'' AS NM_TRANSP,
	2 AS FRETE,
	'Nota fiscal nr.: ' + CONVERT(VARCHAR(10),NR_NF) + ' Filial origem.: ' + CONVERT(VARCHAR(10),CD_FORN) AS OBS,
	1 AS CD_USU,
	0 AS STS_PED,
	CONVERT(VARCHAR(10),GETDATE(),112) AS DT_FAT,
	VLR_TOT_PROD,
	0 AS VLR_DESC,
	CONVERT(VARCHAR(10),GETDATE()+8,112) AS DT_VALID,
	CONVERT(VARCHAR(10),GETDATE(),112) AS DT_CAD,
	NULL AS DT_ULT_ALT,
	NULL AS DT_BX,
	0 AS TP_BX,
	CONVERT(VARCHAR(10),GETDATE(),108) AS HORA_CAD,
	0 AS TP_PED,
	0 AS VLR_FRETE,
	'' AS OBS_NF1,
	'' AS OBS_NF2,
	0 AS PRZ_ENTRG,
	0 AS PRZ_VLD,
	0 AS COB,
	0 AS QT_VOL,
	GETDATE() AS DT_GRAVACAO,
	0 AS BLOQ_FATURAMENTO,
	0 AS VLR_ICMS_SUBS,
	0 AS VLR_ICMS_RETIDO,
	0 AS VLR_OUTROS_IT,
	0 AS FLAG_VALID_TRIB,
	NULL AS XML_PEDIDO,
	0 AS FLAG_REALIZAR_FAT,
	CONVERT(VARCHAR(10),GETDATE(),112) AS DT_NF_SAIDA,
	0 AS FLAG_NAO_CALCULAR_IMPOSTO,
	0 AS VLR_BASE_ICMS,
	0 AS VLR_ICMS,
	0 AS VLR_BASE_ICMS_ST,
	0 AS VLR_IPI,
	'' AS ESP_VOL,
	'' AS MC_VOL,
	0 AS NR_VOL,
	0 AS PESO_VOL,
	0 AS PESO_LIQ_VOL,
	'' AS OBS_NF4,
	'' AS OBS_NF5,
	'' AS OBS_NF6,
	'' AS OBS_NF7,
	'' AS OBS_NF8,
	'' AS OBS_NF9,
	'' AS OBS_NF10,
	'' AS OBS_NF11,
	0 AS VLR_RESSARCIMENTO_BASE_SUBST,
	0 AS VLR_RESSARCIMENTO_ICMS_SUBST,
	0 AS VLR_ADJ_BASE_ICMS,
	0 AS VLR_ADJ_ICMS,
	0 AS CD_TRANSP,
	'' AS PLACA_VEIC,
	'' AS PLACA_UF,
	'' AS CGC_CPF_TRANSP,
	'' AS ENDE_TRANSP,
	'' AS DS_CID_TRANSP,
	'' AS UF_TRANSP,
	'' AS INSC_EST_TRANSP,
	'' AS EMAIL_TRANSP,
	GETDATE() AS DT_TRANSACAO,
	0 AS CD_CTR_DEVO
FROM
	EST_NF_ENT
WHERE
	CD_EMP =@CD_EMP
	AND CD_FILIAL = @CD_FILIAL
	AND CD_NF=@CD_NF_ENTRADA


INSERT INTO EST_PED_VD_IT
	(CD_EMP
	,CD_FILIAL
	,CD_PED
	,CD_PROD
	,QT_IT
	,VLR_IT
	,VLR_DESC
	,QT_EST_ANT
	,PERC_IPI
	,PERC_DESC
	,VLR_ICMS_SUBS_FUT
	,VLR_PROD_PED
	,VLR_SUFRAMA
	,ORD_GRAVA
	,PERC_DESC_CTR
	,PERC_COMI
	,PERC_COMI_CTR
	,VALIDADE
	,CD_TRIB
	,VLR_PMC
	,VLR_ICMS_SUBS
	,VLR_ICMS_RETIDO
	,VLR_IMPOSTO_REA
	,VLR_OUTROS_IT
	,VLR_BASE_ICMS_SUBS
	,VLR_BASE_ICMS_IT
	,VLR_TOT_IT
	,VLR_ISENTO
	,VLR_OUTROS
	,PERC_REDU_BASE_SUBS
	,PERC_REDU_BASE_ICMS
	,VLR_PROD_FRETE
	,VLR_BASE_PIS
	,VLR_PIS
	,PERC_ALIQ_PIS
	,VLR_BASE_COFINS
	,VLR_COFINS
	,PERC_ALIQ_COFINS
	,VLR_BASE_ICMS_RET
	,VLR_OUTROS_DESPESAS
	,ALIQ_ICMS
	,VLR_ICMS_IT
	,VLR_CUSTO
	,ALIQ_ICMS_INTERNO
	,PERC_IVA
	,VLR_CUSTO_MD
	,CD_TRIB_SIMPLES
	,VLR_CUSTO_ACERTO
	,VLR_ICMS_DESONERADO
	,ICMS_DESONERADO_MOTIVO
	,PERC_ICMS_DESTINO_DIFAL
	,PERC_ICMS_ORIGEM_DIFAL
	,GERAR_DIFAL)
SELECT
	CD_EMP,
	CD_FILIAL,
	@CD_PED,
	CD_PROD,
	QT_IT,
	VLR_IT,
	VLR_DESC,
	0 AS QT_EST_ANT,
	0 AS PERC_IPI,
	0 AS PERC_DESC,
	0 AS VLR_ICMS_SUBS_FUT,
	0 AS VLR_PROD_PED,
	0 AS VLR_SUFRAMA,
	SEQ_ITEM AS ORD_GRAVA,
	0 AS PERC_DESC_CTR,
	0 AS PERC_COMI,
	0 AS PERC_COMI_CTR,
	0 AS VALIDADE,
	CD_TRIB,
	0 AS VLR_PMC,
	0 AS VLR_ICMS_SUBS,
	0 AS VLR_ICMS_RETIDO,
	0 AS VLR_IMPOSTO_REA,
	0 AS VLR_OUTROS_IT,
	0 AS VLR_BASE_ICMS_SUBS,
	0 AS VLR_BASE_ICMS_IT,
	0 AS VLR_TOT_IT,
	0 AS VLR_ISENTO,
	0 AS VLR_OUTROS,
	0 AS PERC_REDU_BASE_SUBS,
	0 AS PERC_REDU_BASE_ICMS,
	0 AS VLR_PROD_FRETE,
	0 AS VLR_BASE_PIS,
	0 AS VLR_PIS,
	0 AS PERC_ALIQ_PIS,
	0 AS VLR_BASE_COFINS,
	0 AS VLR_COFINS,
	0 AS PERC_ALIQ_COFINS,
	0 AS VLR_BASE_ICMS_RET,
	0 AS VLR_OUTROS_DESPESAS,
	0 AS ALIQ_ICMS,
	0 AS VLR_ICMS_IT,
	0 AS VLR_CUSTO,
	0 AS ALIQ_ICMS_INTERNO,
	0 AS PERC_IVA,
	0 AS VLR_CUSTO_MD,
	0 AS CD_TRIB_SIMPLES,
	0 AS VLR_CUSTO_ACERTO,
	0 AS VLR_ICMS_DESONERADO,
	0 AS ICMS_DESONERADO_MOTIVO,
	0 AS PERC_ICMS_DESTINO_DIFAL,
	0 AS PERC_ICMS_ORIGEM_DIFAL,
	0 AS GERAR_DIFAL
FROM
	EST_NF_ENT_IT
WHERE
	CD_EMP =@CD_EMP
	AND CD_FILIAL = @CD_FILIAL
	AND CD_NF=@CD_NF_ENTRADA


INSERT INTO EST_NF_ENT_CROSS_DOCKING
(CD_EMP,
CD_FILIAL,
CD_NF,
CD_USU,
DT_CAD)
SELECT
	@CD_EMP,
	@CD_FILIAL,
	@CD_NF_ENTRADA,
	1,
	GETDATE()